<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Race extends Model 
{

    protected $table = 'races';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function track()
    {
        return $this->belongsTo('Track', 'track_id');
    }

    public function drivers()
    {
        return $this->hasMany('Driver');
    }

}